/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.world.gen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.infernalstudios.infernalexp.init.IEStructureTypes;
import org.infernalstudios.infernalexp.world.gen.structures.StructureUtil;
import org.jetbrains.annotations.NotNull;

public class SizeCheckingNetherStructure
extends Structure {
    public static final Codec<SizeCheckingNetherStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SizeCheckingNetherStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.INT.fieldOf("size_to_check").forGetter(structure -> structure.sizeToCheck)).apply((Applicative)instance, SizeCheckingNetherStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final int sizeToCheck;

    public SizeCheckingNetherStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int sizeToCheck) {
        super(settings);
        this.startPool = startPool;
        this.sizeToCheck = sizeToCheck;
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(@NotNull Structure.GenerationContext context) {
        Optional<Integer> yLevel = StructureUtil.getSuitableNetherYLevel(context, context.f_226628_().m_151394_(0));
        if (yLevel.isEmpty()) {
            return Optional.empty();
        }
        BlockPos pos = context.f_226628_().m_151394_(yLevel.get().intValue());
        for (int x = pos.m_123341_() - this.sizeToCheck; x <= pos.m_123341_() + this.sizeToCheck; x += this.sizeToCheck) {
            for (int z = pos.m_123343_() - this.sizeToCheck; z <= pos.m_123343_() + this.sizeToCheck; z += this.sizeToCheck) {
                if (StructureUtil.checkLandAtHeight(context, pos, 5)) continue;
                return Optional.empty();
            }
        }
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, Optional.empty(), (int)1, (BlockPos)pos, (boolean)false, Optional.empty(), (int)1);
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return IEStructureTypes.SIZE_CHECKING_NETHER_STRUCTURE;
    }
}

